import { S as SelectInput, I as Icon } from "./Layout-p-cBGERf.js";
import { Link } from "@inertiajs/vue3";
import moment from "moment";
import { T as TaskDetails } from "./TaskDetails-BGOpLfqj.js";
import axios from "axios";
import { D as DeleteConfirmation } from "./DeleteConfirmation-B5REE71A.js";
import { resolveComponent, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, useSSRContext } from "vue";
import { ssrRenderStyle, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrRenderClass, ssrIncludeBooleanAttr, ssrLooseEqual } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  name: "right-menu",
  props: {
    project: Object,
    top: { required: false, default: "45px" },
    left: { required: false, default: "inherit" },
    right: { required: false, default: 0 }
  },
  emits: {
    openTask: null,
    menuToggle: null
  },
  components: { DeleteConfirmation, TaskDetails, SelectInput, Icon, Link },
  data() {
    return {
      enable_options: { tasks: false, boards: false, workspaces: false, backgrounds: false, visibility: false },
      show_back_button: false,
      upload_project_bg: null,
      delete_project_confirmation: false,
      selected_workspace: this.project.workspace_id,
      selected_background: this.project.background,
      menu_data: { tasks: [], boards: [], workspaces: [], backgrounds: [] }
    };
  },
  methods: {
    projectBgChange(e) {
      if (e.target.files.length) {
        this.upload_project_bg = e.target.files[0];
      }
    },
    async uploadBackground(e) {
      e.preventDefault();
      if (!this.upload_project_bg) {
        return;
      }
      if (this.upload_project_bg.size / 1024 / 1024 > 2) {
        alert("Uploading file size less than 2MB is not allowed in the demo mode!");
        return;
      }
      let formData = new FormData();
      formData.append("file", this.upload_project_bg);
      const resp = await axios.post(this.route("project.background.upload", this.project.id), formData, {
        headers: {
          "Content-Type": "multipart/form-data"
        }
      });
      if (resp.data && resp.data.image) {
        const bg_resp = await axios.post(this.route("project.background.update", this.project.id), { background_id: resp.data.id });
        if (bg_resp && bg_resp.data) {
          this.project.background = bg_resp.data;
          if (this.$page.props.project) {
            this.$page.props.project.background = bg_resp.data;
            this.upload_project_bg = null;
            this.$refs.projectBgUpload.value = null;
          }
        }
      }
    },
    changeBackground(background) {
      this.selected_background = background;
      this.project.background = background;
      axios.post(this.route("project.background.update", this.project.id), { background_id: background.id, color: null });
      if (this.$page.props.project) {
        this.$page.props.project.background = background;
      }
    },
    async changeProjectVisibility(is_private) {
      await axios.post(this.route("project.update", this.project.id), { is_private });
      window.location.href = this.route("projects.view.board", this.project.slug || this.project.id);
    },
    deleteProject() {
      this.delete_project_confirmation = false;
      this.$emit("menuToggle");
      this.$inertia.delete(this.route("project.destroy", this.project.id));
    },
    goBack() {
      const options = this.enable_options;
      Object.keys(options).forEach(function(key) {
        options[key] = false;
      });
      this.show_back_button = false;
    },
    showItems(type) {
      this.enable_options[type] = true;
      this.show_back_button = true;
      if (type !== "visibility") {
        this.getItem(type);
      }
    },
    async getItem(type) {
      const archiveData = await axios.get(this.route("json.menu_data." + type, this.project.id));
      this.menu_data[type] = archiveData.data;
    },
    async sendToBoard(id) {
      await axios.post(this.route("json.board.remove.archive", id));
      await this.getItem("boards");
    },
    async changeWorkSpace(workspace_id) {
      await axios.post(this.route("json.workspace.change"), { workspace_id, project_id: this.project.id });
      window.location.href = this.route("projects.view.board", this.project.slug || this.project.id);
    }
  },
  created() {
    this.moment = moment;
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_icon = resolveComponent("icon");
  const _component_Link = resolveComponent("Link");
  const _component_select_input = resolveComponent("select-input");
  const _component_delete_confirmation = resolveComponent("delete-confirmation");
  _push(`<!--[--><div class="right__menu fixed w-[290px] z-[200] h-[calc(100%-45px)] shadow text-sm bg-[#ffffff] shadow overflow-hidden" style="${ssrRenderStyle({ top: $props.top, left: $props.left, right: $props.right })}"><div class="flex relative gap-3 flex-col py-3 px-3"><div class="flex items-center justify-between gap-1"><div class="flex">`);
  if ($data.show_back_button) {
    _push(`<div class="top__control">`);
    _push(ssrRenderComponent(_component_icon, {
      name: "arrow-left",
      class: "w-4 h-4"
    }, null, _parent));
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div><div class="flex text-center">${ssrInterpolate(_ctx.$t("Menu"))}</div><div class="top__control">`);
  _push(ssrRenderComponent(_component_icon, {
    class: "w-4 h-4",
    name: "close"
  }, null, _parent));
  _push(`</div></div></div>`);
  if (!$data.show_back_button) {
    _push(`<ul class="buttons"><li><button>`);
    _push(ssrRenderComponent(_component_icon, { name: "archive" }, null, _parent));
    _push(` ${ssrInterpolate(_ctx.$t("Archived Tasks"))}</button></li><li><button>`);
    _push(ssrRenderComponent(_component_icon, { name: "archive" }, null, _parent));
    _push(` ${ssrInterpolate(_ctx.$t("Archived Board Items"))}</button></li>`);
    if (_ctx.$page.props.auth.user.role.slug === "admin") {
      _push(`<li class="border-t"><a${ssrRenderAttr("href", "/project/csv/export/" + $props.project.id)}><img class="w-5 h-5 mr-1" src="/images/svg/csv.svg" alt="Export CSV"> ${ssrInterpolate(_ctx.$t("Export tasks as CSV"))}</a></li>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.$page.props.auth.user.role.slug === "admin") {
      _push(`<li><a${ssrRenderAttr("href", "/project/excel/export/" + $props.project.id)}><img class="w-5 h-5 mr-1" src="/images/svg/excel.svg" alt="Export Excel"> ${ssrInterpolate(_ctx.$t("Export tasks as Excel"))}</a></li>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.$page.props.auth.user.role.slug === "admin") {
      _push(`<li class="border-t"><button><span class="icon" style="${ssrRenderStyle([$props.project && $props.project.background ? { backgroundImage: "url(" + $props.project.background.image + ")" } : {}])}"></span> ${ssrInterpolate(_ctx.$t("Change Background"))}</button></li>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.$page.props.auth.user.role.slug === "admin") {
      _push(`<li><button>`);
      _push(ssrRenderComponent(_component_icon, { name: "gear" }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Change Workspace"))}</button></li>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.$page.props.auth.user.role.slug === "admin") {
      _push(`<li><button>`);
      _push(ssrRenderComponent(_component_icon, { name: "display" }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Change Task Visibility"))}</button></li>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.$page.props.auth.user.role.slug === "admin") {
      _push(`<li><button>`);
      _push(ssrRenderComponent(_component_icon, { name: "trash" }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Delete Project"))}</button></li>`);
    } else {
      _push(`<!---->`);
    }
    if (_ctx.$page.props.auth.user.role.slug === "admin") {
      _push(`<li>`);
      _push(ssrRenderComponent(_component_Link, {
        href: _ctx.route("global")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_icon, { name: "settings" }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(_ctx.$t("Global Settings"))}`);
          } else {
            return [
              createVNode(_component_icon, { name: "settings" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("Global Settings")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</ul>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.enable_options["tasks"]) {
    _push(`<div class="flex items-center flex-col px-2 w-full border-t pt-3"><!--[-->`);
    ssrRenderList($data.menu_data.tasks, (element) => {
      _push(`<div class="flex w-full"><div${ssrRenderAttr("data-id", element.id)} class="flow-root p-2 w-full t__box border relative flex flex-col items-start mb-2 bg-white rounded-lg cursor-pointer bg-opacity-90 group hover:bg-opacity-100" draggable="true"><h4 class="text-sm font-medium mb-1">${ssrInterpolate(element.title)}</h4><div class="${ssrRenderClass([{ "completed": element.checklist_done_count === element.checklists_count, "done": element.is_done }, "flex flex-wrap float-left items-center mb-1 text-xs font-medium gap-2 card__footer"])}">`);
      if (element.due_date) {
        _push(`<div class="flex items-center __item due" aria-label="Due date">`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4",
          name: "time"
        }, null, _parent));
        _push(`<span class="pl-[2px] pr-[4px] leading-none">${ssrInterpolate(_ctx.moment(element.due_date).format("MMM D"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (element.description) {
        _push(`<div class="flex items-center __item" aria-label="This task has a description.">`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4",
          name: "details"
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (element.comments_count) {
        _push(`<div class="relative flex items-center __item" aria-label="Comments">`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4",
          name: "comment"
        }, null, _parent));
        _push(`<span class="ml-1 leading-none">${ssrInterpolate(element.comments_count)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (element.attachments_count) {
        _push(`<div class="flex items-center __item" aria-label="Attachments">`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4",
          name: "attachment"
        }, null, _parent));
        _push(`<span class="ml-1 leading-none">${ssrInterpolate(element.attachments_count)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (element.checklists_count) {
        _push(`<div class="flex items-center __item check" aria-label="Checklist items">`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4",
          name: "checklist"
        }, null, _parent));
        _push(`<span class="ml-1 leading-none">${ssrInterpolate(element.checklist_done_count + "/" + element.checklists_count)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
    });
    _push(`<!--]-->`);
    if (!$data.menu_data.tasks.length) {
      _push(`<div class="flex">${ssrInterpolate(_ctx.$t("No task found!"))}</div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.enable_options["boards"]) {
    _push(`<div class="flex archive___board items-center flex-col px-2 w-full border-t pt-3"><!--[-->`);
    ssrRenderList($data.menu_data.boards, (list) => {
      _push(`<div class="item"><div class="b__title">${ssrInterpolate(list.title)}</div><button class="btn">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "mr-1 h-3 w-3",
        name: "undo"
      }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Send to board"))}</button></div>`);
    });
    _push(`<!--]-->`);
    if (!$data.menu_data.boards.length) {
      _push(`<div class="flex">${ssrInterpolate(_ctx.$t("No list found!"))}</div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.enable_options["workspaces"]) {
    _push(`<div class="flex archive___board items-center flex-col px-3 w-full border-t pt-3">`);
    _push(ssrRenderComponent(_component_select_input, {
      modelValue: $data.selected_workspace,
      "onUpdate:modelValue": ($event) => $data.selected_workspace = $event,
      class: "w-full"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`<option${ssrRenderAttr("value", null)}${_scopeId}>${ssrInterpolate(_ctx.$t("Select a workspace"))}</option><!--[-->`);
          ssrRenderList($data.menu_data["workspaces"], (workspace, wi) => {
            _push2(`<option${ssrRenderAttr("value", workspace.id)}${_scopeId}>${ssrInterpolate(workspace.name)}</option>`);
          });
          _push2(`<!--]-->`);
        } else {
          return [
            createVNode("option", { value: null }, toDisplayString(_ctx.$t("Select a workspace")), 1),
            (openBlock(true), createBlock(Fragment, null, renderList($data.menu_data["workspaces"], (workspace, wi) => {
              return openBlock(), createBlock("option", {
                key: wi,
                value: workspace.id
              }, toDisplayString(workspace.name), 9, ["value"]);
            }), 128))
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`<button class="w-full mt-2 btn action justify-center">${ssrInterpolate(_ctx.$t("Save"))}</button></div>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.enable_options["visibility"]) {
    _push(`<div class="flex archive___board items-center flex-col px-3 w-full border-t pt-3"><div class="flex"><div class="flex items-center h-5"><input id="helper-checkbox"${ssrIncludeBooleanAttr(ssrLooseEqual($props.project.is_private, "1")) ? " checked" : ""} aria-describedby="helper-checkbox-text" type="checkbox" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded dark:bg-gray-700 dark:border-gray-600"></div><div class="ms-1 text-sm"><label for="helper-checkbox" class="font-medium text-[14px] text-gray-900 dark:text-gray-300">${ssrInterpolate(_ctx.$t("Visible tasks only for the assigned people."))}</label><p class="pt-2">${ssrInterpolate(_ctx.$t("Enabling this the tasks will be visible only for the admin and assigned people"))}</p></div></div><button class="w-full mt-2 btn action justify-center">${ssrInterpolate(_ctx.$t("Save"))}</button></div>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.enable_options["backgrounds"]) {
    _push(`<div class="create__project flex flex-col px-3 w-full border-t pt-3"><label class="flex flex-col"><div class="title mb-2">${ssrInterpolate(_ctx.$t("Background"))}</div><div class="color__list"><ul class="grid grid-rows-2 grid-flow-col gap-[9px]"><!--[-->`);
    ssrRenderList($data.menu_data["backgrounds"], (color) => {
      _push(`<li class="flex"><button class="w-10 h-8 flex items-center justify-center rounded" style="${ssrRenderStyle({ backgroundImage: "url(" + color.image + ")", backgroundColor: color.bg })}">`);
      if ($data.selected_background && $data.selected_background.id === color.id) {
        _push(ssrRenderComponent(_component_icon, {
          name: "tick_check",
          class: "text-white w-4 h-4"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></li>`);
    });
    _push(`<!--]--></ul></div></label><div class="flex flex-col mt-4"><label class="block mb-2 text-gray-900 dark:text-white" for="projectBgUpload">Upload file</label><input id="projectBgUpload" class="block w-full text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" type="file"><p class="mt-1 text-sm text-gray-500 dark:text-gray-300" id="file_input_help">SVG, PNG, JPG or GIF (MAX. 2MB).</p>`);
    if ($data.upload_project_bg) {
      _push(`<button class="w-full mt-2 btn action justify-center">${ssrInterpolate(_ctx.$t("Save"))}</button>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
  if ($data.delete_project_confirmation) {
    _push(ssrRenderComponent(_component_delete_confirmation, {
      onPopup: ($event) => $data.delete_project_confirmation = false,
      onConfirm: ($event) => $options.deleteProject(),
      details: "Deleting project will delete all of the tasks including board list. Are you sure you want to delete this project?"
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`<!--]-->`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/RightMenu.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const RightMenu = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  RightMenu as R
};
